/**
 * autoscroll
 * 
 * @license     http://www.opensource.org/licenses/mit-license.html  MIT License
 * @copyright   RaNa design associates, inc.
 * @author      keisuke YAMAMOTO <keisukey@ranadesign.com>
 * @link        http://kaelab.ranadesign.com/
 * @version     1.0
 * @date        2012
 *
 */
(function($) {

	$(function() {
		// ページトップへ自動スクロール移動
		$(".pagetop").click(function(event) {
			$("html, body").animate({
				scrollTop: 0
			});
			event.preventDefault();
		});
		
		// スクロール位置がドキュメントの30％より下にあるとき
		$(window).scroll(function() {
			var s = $(window).scrollTop() / ($(document).height() - $(window).height());
			if (s > 0.3) {
				$(".pagetop").fadeIn();
			} else {
				$(".pagetop").fadeOut();
			}
		});
		
		// スクロールを上に移動
		$(".scrollto_1").click(function(event) {
			$("html, body").animate({
				scrollTop: $(window).scrollTop() - 200
			});
			event.preventDefault();
		});

		// スクロールを下に移動
		$(".scrollto_2").click(function(event) {
			$("html, body").animate({
				scrollTop: $(window).scrollTop() + 400
			});
			event.preventDefault();
		});

		// スクロールが上下両端にあるとき、ボタンを無効にする。
		$(window).scroll(function() {
			var s = $(window).scrollTop() / ($(document).height() - $(window).height());
			// スクロール位置が上端のとき
			if (s === 0) {
				$(".scrollto_1").addClass("disabled");
			} else {
				$(".scrollto_1").removeClass("disabled");
			}
			// スクロール位置が下端のとき
			if (s === 1) {
				$(".scrollto_2").addClass("disabled");
			} else {
				$(".scrollto_2").removeClass("disabled");
			}
		}).scroll();
	});

})(jQuery);
