/*
JavaScript for the demo: Recreating the Nikebetterworld.com Parallax Demo
Demo: Recreating the Nikebetterworld.com Parallax Demo
Author: Ian Lunn
Author URL: http://www.ianlunn.co.uk/
Demo URL: http://www.ianlunn.co.uk/demos/recreate-nikebetterworld-parallax/
Tutorial URL: http://www.ianlunn.co.uk/blog/code-tutorials/recreate-nikebetterworld-parallax/

License: http://creativecommons.org/licenses/by-sa/3.0/ (Attribution Share Alike). Please attribute work to Ian Lunn simply by leaving these comments in the source code or if you'd prefer, place a link on your website to http://www.ianlunn.co.uk/.

Dual licensed under the MIT and GPL licenses:
http://www.opensource.org/licenses/mit-license.php
http://www.gnu.org/licenses/gpl.html
*/

$(document).ready(function() { //when the document is ready...
$(document).ready(function(){
		$("#second")
		.prepend('<div class="bg"></div>')
		$("#fourth")
		.prepend('<div class="bg"></div>')
});

	//save selectors as variables to increase performance
	var $window = $(window);
	var $firstBG = $('#first');
	var left = $("#first .float-left");
	var h1 = $("#first .float-left h1");
	var $secondBG = $('#second');
	var sbg = $("#second .bg");
	var sbox = $("#second .box");
	var $thirdBG = $('#third');
	var $fourthBG = $('#fourth');
	var fbox = $("#fourth .float-right a");
	var fbg = $("#fourth .bg");
	var windowHeight = $window.height(); //get the height of the window
	
	
	//apply the class "inview" to a section that is in the viewport
	$('#first, #second, #third, #fourth').bind('inview', function (event, visible) {
			if (visible == true) {
			$(this).addClass("inview");
			} else {
			$(this).removeClass("inview");
			}
		});
	
			
	//function that places the navigation in the center of the window
	function RepositionNav(){
		var windowHeight = $window.height(); //get the height of the window
		var navHeight = $('#nav').height() / 2;
		var windowCenter = (windowHeight / 2); 
		var newtop = windowCenter - navHeight;
		$('#nav').css({"top": newtop}); //set the new top position of the navigation list
	}
	
	//function that is called for every pixel the user scrolls. Determines the position of the background
	/*arguments: 
		x = horizontal position of background
		windowHeight = height of the viewport
		pos = position of the scrollbar
		adjuster = adjust the position of the background
		inertia = how fast the background moves in relation to scrolling
	*/
	function newPos(x, windowHeight, pos, adjuster, inertia){
		return x + "% " + (-((windowHeight + pos) - adjuster) * inertia)  + "px";
	}
	
	//function to be called whenever the window is scrolled or resized
	function Move(){ 
		var pos = $window.scrollTop(); //position of the scrollbar

		if($firstBG.hasClass("inview")){
			$firstBG.css({'backgroundPosition': newPos(50, windowHeight, pos, 100, 0.3)}); 
			left.css({'backgroundPosition': newPos(35, windowHeight, pos, 600, 0.1)});
			h1.css({'backgroundPosition': newPos(54, windowHeight, pos, 1000, 0.2)});
		}
		
		if($secondBG.hasClass("inview")){
			$secondBG.css({'backgroundPosition': newPos(50, windowHeight, pos, 1000, 0.1)});
			sbg.css({'backgroundPosition': newPos(50, windowHeight, pos, 840, 0.3)});
			sbox.css({'backgroundPosition': newPos(50, windowHeight, pos, 800, 0.2)});
		}
		
		if($thirdBG.hasClass("inview")){
			$thirdBG.css({'backgroundPosition': newPos(50, windowHeight, pos, 500, 0.3)});
		}
		
		if($fourthBG.hasClass("inview")){
			$fourthBG.css({'backgroundPosition': newPos(50, windowHeight, pos, 1800, 0.1)});
			fbg.css({'backgroundPosition': newPos(20, windowHeight, pos, 2800, 0.9)});
			fbox.css({'backgroundPosition': newPos(50, windowHeight, pos,3500, 0.2)});
		}
		
		$('#pixels').html(pos); //display the number of pixels scrolled at the bottom of the page
	}
		
	RepositionNav(); //Reposition the Navigation to center it in the window when the script loads
	
	$window.resize(function(){ //if the user resizes the window...
		Move(); //move the background images in relation to the movement of the scrollbar
		RepositionNav(); //reposition the navigation list so it remains vertically central
	});		
	
	$window.bind('scroll', function(){ //when the user is scrolling...
		Move(); //move the background images in relation to the movement of the scrollbar
	});
	
});